# - bof - #



# -  - #
# - update_ - #
function update_(){
  echo -e "\nUpdating system...\n";
  case $Opt in
    1)
      sudo apt update && sudo apt upgrade -y && sudo apt autoremove -y;        
      ;;
    2)
      sudo pacman -Syu --noconfirm && sudo pacman -Syyuu --noconfirm;        
      ;;
    3)
      sudo dnf update -y;        
      ;;
    *)
      echo "Option no valid: " $Opt;
      ;;
  esac
  echo -e "\nSystem was updated...\n\n\n";
  sleep 10;
}



# -  - #
# - distroVersion_ - #
function distroVersion_(){
  local sD_='' sS1_='';
  sD_='debian';
  sS1_=$( dvLook_ $sD_ );
  if [ "$sS1_" == "$sD_" ]; then
    Opt=1;
  else
    sD_='ubuntu';
    sS1_=$( dvLook_ $sD_ );
    if [ "$sS1_" == "$sD_" ]; then
      Opt=1;
    else
      sD_='arch';
      sS1_=$( dvLook_ $sD_ );
      if [ "$sS1_" == "$sD_" ]; then
        Opt=2;
      else
        sD_='red hat';
        sS1_=$( dvLook_ "$sD_" );
        if [ "$sS1_" == "$sD_" ]; then
          Opt=3;
        fi;
      fi;
    fi;
  fi;
}



# -  - #
# - Distro version look - #
# - dvLook_ - #
function dvLook_(){
  local sD1_=$1 \
        sP_=$(cat /proc/version);
  sP_=$( sed -e 's/\(.*\)/\L\1/' <<< "$sP_"  | grep -oF "$sD1_" | uniq );
  echo $sP_;
}



# -  - #
# - weztermConfiguration_ - #
function weztermConfiguration_(){
  local sMsg_="Configuring wezTerm..." \
        eWs_="/wezTerm/wezTerm-Configuration/" \
        wTar_=wezTem.tar.bz2 \
        wD_=~/.config/wezterm/ \
        sDwn_=~/Downloads;
  local bWServer_=$uWServer_$eWs_$wTar_;

  echo -e "\n\n$sMsg_\n\n";
  mkdir -pv $wD_;
  mkdir -p $sDwn_;
  cd $sDwn_;

  # -  - #
  # - ~/Downloads/wezTem.tar.bz2 - #
  curl -O $bWServer_;
  echo -e "\n";
  tar -xvf $wTar_ -C ~/;
  rm -rf $wTar_;

  cd $Dir_;
  echo -e "\n\nwezTerm was configured successfully...\n\n\n";
  sleep 5;
}



# -  - #
# - wezTerm - #
function wezTerm(){
  echo -e "\nInstalling $sWt_...\n";

  remotesAdd_;

  flatpak install flathub org.wezfurlong.$sWt_ -y;

  echo -e "\n$sWt_ was installed successfully...\n\n\n";
}



# -  - #
# - remoteAdd_ - #
function remotesAdd_(){
  echo -e "\nInstalling remotes...\n";

  flatpak remote-add --if-not-exists flathub https://dl.flathub.org/repo/flathub.flatpakrepo
  flatpak remote-add --if-not-exists appcenter https://flatpak.elementary.io/repo.flatpakrepo
  flatpak remote-add --if-not-exists fedora oci+https://registry.fedoraproject.org
  flatpak remote-add --if-not-exists gnome-nightly https://nightly.gnome.org/gnome-nightly.flatpakrepo
  flatpak remote-add --if-not-exists webkit-sdk https://software.igalia.com/flatpak-refs/webkit-sdk.flatpakrepo
  flatpak remote-add --if-not-exists zorinos https://flatpak.zorinos.com/repo/
 #flatpak remote-add --no-gpg-verify zorinos https://flatpak.zorinos.com/repo/


  echo -e "\nRemotes were installed successfully...\n\n\n";
}



# -  - #
# - wareHouse_ - #
function wareHouse_(){
  local sWh_="Warehouse";
  echo -e "\nInstalling $sWh_...\n";

  remotesAdd_;

  flatpak install flathub io.github.flattool.$sWh_ -y;
  flatpak install flathub org.wezfurlong.wezterm -y;
  flatpak install fedora  com.gexperts.Tilix -y;

  flatpakSoftware_;

  echo -e "\n$sWh_ was installed successfully...\n\n\n";
  #sleep 10;
}



# -  - #
# - flatpakSoftware_ - #
function flatpakSoftware_(){

  echo -e "\n\n\n\n\n\n"

  figlet "Flatpak" | lolcat;
  figlet "Software" | lolcat;

  echo -e "\n\n\n"

  while true; do
    read -p "Do you want to install flatpak studio software? (Yy/Nn): " yn
    case $yn in
        [Yy]* )
          echo -e "\n\nInstalling flatpak studio software...\n\n"

          flatpak install flathub org.kde.kdenlive -y;
          flatpak install fedora  com.obsproject.Studio -y;
          flatpak install flathub org.kde.krita -y;
          flatpak install flathub org.inkscape.Inkscape -y;
          flatpak install flathub com.github.vikdevelop.photopea_app -y;
          flatpak install flathub fr.natron.Natron -y;

          echo -e "\n\nFlatpak studio software was installed successfully...\n\n\n"
          sleep 10;
          break;;
        [Nn]* )
          break;;
        * ) echo "Please answer (y)es or (n)o.";;
    esac
  done
}



# -  - #
# - iUbuntu_ - #
function iUbuntu_(){
  echo -e "\nInstalling $sFp_...\n";

  sudo apt install $sFp_ fonts-font-awesome -y 

  echo -e "\n$sFp_ was installed successfully...\n\n\n";
  sleep 10;
}



# -  - #
# - iArch_ - #
function iArch_(){
  echo -e "\nInstalling $sFp_...\n";

  sudo pacman -S $sFp_ ttf-font-awesome --noconfirm --needed;

  echo -e "\n$sFp_ was installed successfully...\n\n\n";
  sleep 10;
}



# -  - #
# - iFedora_ - #
function iFedora_(){
  echo -e "\nInstalling $sFp_...\n";

  sudo dnf install $sFp_ fontawesome-fonts-all -y;

  echo -e "\n$sFp_ was installed successfully...\n\n\n";
  sleep 10;
}



# -  - #
# - installFlatpak_ - #
function installFlatpak_(){
  case $Opt in
    ''|*[!0-9]*)
      echo -e "\nIts not a number...";
      ;;
    1)
      iUbuntu_;
      ;;
    2)
      iArch_;
      ;;
    3)
      iFedora_;
      ;;
    *)
      echo "Option no valid: " $Opt;
      ;;
  esac
}



# -  - #
# - checkComputer_ - #
function checkComputer_(){
  local sMsg_="This process cannot be executed on: $hostName_...";

  if [ "$overwriteCc_" == "Yes" ]; then
    return; fi;

  echo -e '\nChecking computer...\n';
  if [ "$hostName_" == "HPLaptopArch" ] || [ "$hostName_" == "HPDesktopArch" ]; then
    rm -rf ~/Arch_Xfce-FinalConfiguration.sh;
    echo -e "\n$sMsg_\n\n\n";
    sleep 10;
    exit;
  fi;
  echo "";
}



# -  - #
# - Log_ - #
function Log_(){
  local nO_=$1 \
        sM1_="ArchInstall\nPrograms not installed:" \
        sM2_="Arch_PostInstallation\nPrograms not installed:" \
        sM3_="Arch_Xfce-Desktop-Install\nPrograms not installed:" \
        sM4_="Arch_Cinnamon-Desktop-Install\nPrograms not installed:" \
        sM5_="Arch_Gnome-Desktop-Install\nPrograms not installed:";

  if [ -f "$logF_" ]; then
    rm -rf $logF_; fi;

  if [ "$nO_" == "1" ]; then
    lMsg_=$sM1_;
  elif [ "$nO_" == "2" ]; then
    lMsg_=$sM2_;
  elif [ "$nO_" == "3" ]; then
    lMsg_=$sM3_;
  elif [ "$nO_" == "4" ]; then
    lMsg_=$sM4_;
  elif [ "$nO_" == "5" ]; then
    lMsg_=$sM5_;
  fi;

  echo -e "$lMsg_\n" > $logF_;
  echo -e "\nCreating the log file...    check for errors...";
  echo -e "\n10 seconds pause...\n\n\n";
  sleep 10;
}



# -  - #
# - create-zRam_ - #
function createzRam_(){
  local zRamCnf_=/etc/systemd/zram-generator.conf \
        tzRamCnf_=~/tzRamCnf_.tmp;
  echo -e "\n\nInstall zram...";

  lPrograms1_="zram-generator";
  tInstall_=$(sPackages_ "$lPrograms1_");
  pacman -S $tInstall_ --noconfirm --needed;

  if [ -f "$zRamCnf_" ]; then
    echo "$zRamCnf_ already exists!"
  else
	  touch $tzRamCnf_;
	  echo "[zram0]" > $tzRamCnf_;
	  echo "zram-size = ram / 2" >> $tzRamCnf_;
	  echo "compression-algorithm = zstd" >> $tzRamCnf_;
	  echo "swap-priority = 100" >> $tzRamCnf_;
	  echo "fs-type = swap" >> $tzRamCnf_;

    mv $tzRamCnf_ $zRamCnf_;

    echo -e "\n\n$zRamCnf_ details...\n";
    cat $zRamCnf_;

    systemctl daemon-reload;
    systemctl start /dev/zram0;
  fi;
  echo -e "\nDONE! Reboot now and check with free -h the ZRAM installation.";
}



# -  - #
# - sPackages_ - #
function sPackages_(){
  local sS1_='' sS2_='' sS3_='' sS4_='' \
        lPacks_=$1;
  
  while true;
  do
    sS1_=$(echo "$lPacks_" | awk '{print $1}');
    lPacks_=$(echo "${lPacks_/$sS1_/"$sS2_"}");

    sS4_=$(echo $(pacman -Ssq | grep -oF "$sS1_" ) | awk '{print $1;}' );
    if [ "$sS4_" != "" ]; then
      sS3_=$sS3_" "$sS1_;
    else
      echo -e "$sS1_" >> $logF_;
    fi;
    sS1_='';

    lPacks_=$(echo "$lPacks_" | xargs);
    if [[ "$lPacks_" == "" ]]; then
      break; fi;
  done
  echo $sS3_;
}



# -  - #
# - xorg_ - #
function xorg_(){
  echo -e "\nInstalling xOrg server...";

  lPrograms1_="xorg xorg-server xorg-xinit";
  tInstall_=$(sPackages_ "$lPrograms1_");
  sudo pacman -S $tInstall_ --noconfirm --needed;

  echo -e "\nxOrg server was installed successfully...\n\n";
  sleep 10;
}



# -  - #
# - gdm_ - #
function gdm_(){
  local sS1_='gdm' sS2_='';

  # -  - #
  # - gdm (Gnome) - #

  sS2_=$( echo $(pacman -Qqe | grep "$sS1_" ) | awk '{print $1;}');
  if [ "$sS1_" == "$sS2_" ]; then echo "Gdm login manager already installed..."; sleep 5; return; fi;

  echo -e "\nInstalling Gdm login manager...";

  lPrograms1_="gdm";
  tInstall_=$(sPackages_ "$lPrograms1_");
  sudo pacman -S $tInstall_ --noconfirm --needed;

  sudo systemctl enable gdm;
  echo -e "\nGdm login manager was installed successfully...\n\n";
  sleep 10;
}



# -  - #
# - lightdm_ - #
function lightdm_(){
  local sS1_='lightdm' sS2_='';

  # -  - #
  # - lightdm (Budgie, Cinnamon, Deepin, Mate, OpenBox, Xfce & XMonad) - #

  sS2_=$( echo $(pacman -Qqe | grep "$sS1_" ) | awk '{print $1;}');
  if [ "$sS1_" == "$sS2_" ]; then echo "lightdm login manager already installed..."; sleep 5; return; fi;

  echo -e "\nInstalling lightdm login manager...";

<<'comment'
  light-locker
  sudo pacman -Rns light-locker --noconfirm;
comment

  lPrograms1_="lightdm lightdm-gtk-greeter lightdm-gtk-greeter-settings accountsservice";
  tInstall_=$(sPackages_ "$lPrograms1_");
  sudo pacman -S $tInstall_ --noconfirm --needed;

  sudo systemctl enable lightdm;
  echo -e "\nLightDM login manager was installed successfully...\n\n";
  sleep 10;
}



# -  - #
# - Wallpapers_ - #
function Wallpapers_(){
  local sWs_=/Arch.Ins/Software.Ins/ \
        sFv_=Various.zip;

  echo -e "\n\nDownloading wallpapers...\n";
  cd ~/Pictures;
  curl -O $uWServer_$sWs_$sFv_;
  unzip $sFv_;

  echo -e "\n\n\nCopying backgrounds files...\n";
  sudo mkdir -p /usr/share/backgrounds;
  sudo mv Various /usr/share/backgrounds/;
  sudo mv Archlinux-icon-crystal_13.png /usr/share/backgrounds/;
  rm -rf Various*;
  cd $Dir_;

  echo -e "\nWallpapers were configured successfully...\n\n\n";
  sleep 5;
}



# -  - #
# - Lightdm_GTK_Greeter_ - #
function Lightdm_GTK_Greeter_(){
  lightdmF_=/etc/lightdm/lightdm-gtk-greeter.conf;

  echo -e "\nConfiguring $lightdmF_...";

  echo '[greeter]' | sudo tee $lightdmF_ > /dev/null;
  sudo sed -i '$ a theme-name = Arc-Dark' $lightdmF_;
  sudo sed -i '$ a icon-theme-name = Arc' $lightdmF_;
  sudo sed -i '$ a default-user-image = /usr/share/backgrounds/Archlinux-icon-crystal_13.png' $lightdmF_;
  sudo sed -i '$ a background = /usr/share/backgrounds/Various/Bonsai-Plant.png' $lightdmF_;
  
  sudo sed -i '$ a reader = xrandr --output Virtual-1 --primary --mode 1920x1080' $lightdmF_;
  sudo sed -i '$ a a11y-states = +reader' $lightdmF_;
  
  echo -e "\n$lightdmF_ was configured successfully...\n\n\n";
  sleep 10;
}



# -  - #
# - FirefoxConfiguration_ - #
function FirefoxConfiguration_(){
  local sPhase_=$1;
  local sWs_=/Arch.Ins/Software.Ins/ \
        sFc_=FirefoxConfigurationFiles.tar.bz2;

  echo -e "\nDownloading firefox configuration files...\n";

<<'comment'
  # -  - #
  # - Documentation - #
  https://www.addictivetips.com/ubuntu-linux-tips/backup-and-restore-a-firefox-profile-on-linux/
  tar -jcvf FirefoxConfigurationFiles.tar.bz2 ~/.mozilla;
comment

  cd ~/Downloads;
  if [ "$sPhase_" == "1" ]; then
    curl -O $uWServer_$sWs_$sFc_; fi;

  echo -e "\n\n\nApplying firefox configuration files...\n";
  rm -rf ~/.mozilla;
  sleep 2;
  rm -rf ~/.mozilla;

  tar -xvf $sFc_ -C ~/ --wildcards *.mozilla;
  if [ "$sPhase_" == "2" ]; then
    rm -rf $sFc_; fi;

  cd $Dir_;
  echo -e "\nFirefox was configured successfully...\n\n\n";
  sleep 5;
}



# -  - #
# - dotConfig_OpenBox_ - #
function dotConfig_OpenBox_(){
  local sPhase_=$1;
  local wF_=/Arch.Ins/Software.Ins/ \
        sFd_=dotConfig_OpenBox.tar.bz2;
        dotConfig_OpenBox_=/Images/Programs/Linux.Img/Linux_Arch.Img/Arch_Install/TilingWindowManager/OpenBoxInstall/dotConfig_OpenBox.tar.bz2 \

  echo -e "\n\nDownloading configuration files...\n";

<<'comment'
  # -  - #
  # - Documentation - #
  tar -jcvf DesktopConfigurationFiles.tar.bz2 ~/.config;
comment

  cd ~/Downloads;
  if [ "$sPhase_" == "1" ]; then
    curl -O $uWServer_$wF_$sFd_; fi;

  echo -e "\n\nApplying configuration files...\n";

  tar -xvf $sFd_ -C ~/ --wildcards *libreoffice;
  tar -xvf $sFd_ -C ~/ --wildcards *gtk-*;
  tar -xvf $sFd_ -C ~/ --wildcards *gedit;


  if [ "$sPhase_" == "2" ]; then
    rm -rf $sFd_; fi;

  cd $Dir_;
  echo -e "\n\nConfiguration files were applied successfully...\n\n\n";
  sleep 5;
}



# -  - #
# - Configuring system - #
function ConfiguringSystem_(){
  local sPhase_=$1;

  if [ "$sPhase_" == "1" ]; then
    Wallpapers_;
    if [ "$Plank_" == "Yes" ]; then
      PlankThemes_; fi;
  fi;

  # 1.Xfce 2.Cinnamon 3.Kde-Plasma 4.Gnome 5.Deepin 6.Budgie 7.OpenBox 8.XMonad 9.NoDesktop
  case $Desktop_ in
    ''|*[!0-9]*)
      echo -e "\nIts not a number...";
      ;;
    1)
      if [ "$sPhase_" == "1" ]; then
        XfceDesktopProgramsShortcuts_; fi;
      dotConfig_Xfce_ $sPhase_;
      ;;
    2)
      dotConfig_Cinnamon_ $sPhase_;
      ;;
    4)
      dotConfig_Gnome_ $sPhase_;
      #GDM_Greeter_ $sPhase_;
      ;;
    7)
      dotConfig_OpenBox_ $sPhase_;
      ;;
    *)
      echo "Option no valid: " $Desktop_;
      ;;
  esac

  FirefoxConfiguration_ $sPhase_;

  if [ "$Desktop_" != "4" ]; then
    Lightdm_GTK_Greeter_ $sPhase_; fi;

}



# - eof - #